// DISingleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DISingle.h"
#include "DISingleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDISingleDlg dialog

CDISingleDlg::CDISingleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDISingleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDISingleDlg)
	m_DIValue = _T("");
	m_device = _T("");
	m_bit0 = FALSE;
	m_trueState = FALSE;
	m_bit1 = FALSE;
	m_bit2 = FALSE;
	m_bit3 = FALSE;
	m_bit4 = FALSE;
	m_bit5 = FALSE;
	m_bit6 = FALSE;
	m_bit7 = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDISingleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDISingleDlg)
	DDX_Control(pDX, IDC_READ, m_readButton);
	DDX_Control(pDX, IDC_INIT, m_initButton);
	DDX_Text(pDX, IDC_DIVALUE, m_DIValue);
	DDX_CBString(pDX, IDC_DEVICE, m_device);
	DDV_MaxChars(pDX, m_device, 1);
	DDX_Check(pDX, IDC_CHECK1, m_bit0);
	DDX_Check(pDX, IDC_CHECK9, m_trueState);
	DDX_Check(pDX, IDC_CHECK2, m_bit1);
	DDX_Check(pDX, IDC_CHECK3, m_bit2);
	DDX_Check(pDX, IDC_CHECK4, m_bit3);
	DDX_Check(pDX, IDC_CHECK5, m_bit4);
	DDX_Check(pDX, IDC_CHECK6, m_bit5);
	DDX_Check(pDX, IDC_CHECK7, m_bit6);
	DDX_Check(pDX, IDC_CHECK8, m_bit7);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDISingleDlg, CDialog)
	//{{AFX_MSG_MAP(CDISingleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_READ, OnRead)
	ON_BN_CLICKED(IDC_INIT, OnInit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDISingleDlg message handlers

BOOL CDISingleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_pSR=NULL;
    m_driverInstance=NULL;  // set our variables equal to something...

	m_trueState = TRUE;  // check the check box
	UpdateData(FALSE);
	
	// populate combo box with legal device numbers, e.g., 0 .. 5
	CComboBox* pComboBox = static_cast<CComboBox*>(GetDlgItem(IDC_DEVICE));
	pComboBox->AddString("0");
	pComboBox->AddString("1");
	pComboBox->AddString("2");
	pComboBox->AddString("3");
	pComboBox->AddString("4");
	pComboBox->AddString("5");
	pComboBox->SetCurSel(0);  // set it equal to the first entry (zero based);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDISingleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDISingleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDISingleDlg::OnClose() 
{
	// code to clean up after DriverLINX
CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
delete(m_pSR); //de-allocate the memory used by the service request
m_pSR=NULL;
	// pass the message on
	CDialog::OnClose();
}

void CDISingleDlg::OnRead() 
{
	// setup a single channel, polled mode DI task
	m_pSR->mode = POLLED;
	m_pSR->operation = START;
	m_pSR->subsystem = DI;
	m_pSR->start.typeEvent = COMMAND;
	m_pSR->stop.typeEvent = TCEVENT;
	m_pSR->timing.typeEvent = NULLEVENT;
	m_pSR->channels.nChannels = 1;  // only one channel
	m_pSR->channels.chanGain[0].channel = 0;   // DI channel 0
		m_pSR->channels.numberFormat = tNATIVE;  // native format, e.g., byte
	if (DriverLINX(m_pSR) == NoErr)
	{  // success
		m_DIValue.Format("%d",m_pSR->status.u.ioValue);  // display the 8bit value
		
		/* status.u.ioValue member of the SR structure can host single value input/output
		   tasks.  No need to allocate and use a buffer when doing single value I/O tasks
		*/

		m_bit0 = (m_pSR->status.u.ioValue & 1) >> 0;  // display the individual lines...
		m_bit1 = (m_pSR->status.u.ioValue & 2) >> 1;
        m_bit2 = (m_pSR->status.u.ioValue & 4) >> 2;
		m_bit3 = (m_pSR->status.u.ioValue & 8) >> 3;
		m_bit4 = (m_pSR->status.u.ioValue & 16) >> 4;
		m_bit5 = (m_pSR->status.u.ioValue & 32) >> 5;
		m_bit6 = (m_pSR->status.u.ioValue & 64) >> 6;
		m_bit7 = (m_pSR->status.u.ioValue & 128) >> 7;

		UpdateData(FALSE); // update the Dialog
	}
    else  // problem has occured
	{  showMessage(m_pSR);}  // display the error message box
	
/*
  This example was written for KPCI-PDISO8A
  It was tested in Win2KSP1 using ISO-850A01 version of DriverLINX for the board

*/
	
}

void CDISingleDlg::OnInit() 
{
	 // Open the driver and Initialize the hardware

// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kpciiso"); //Open DriverLINX driver, and bring up the dialog box to pick a driver
// allocate the SR structure and init the members to zero
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
//  carry out a Initialization operation on the device
UpdateData(TRUE);  //  get the device number from the combo box on the dialog
CComboBox* pComboBox = static_cast<CComboBox*>(GetDlgItem(IDC_DEVICE));
m_pSR->device=pComboBox->GetCurSel(); //set the device number to the device being used
/*
since our device numbers correspond to the selection index in the combo box
just use the GetCurSel() to get the selected device number.....
*/
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
//Execute the initialize service
 //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_readButton.EnableWindow(TRUE);  // enable the Read button
m_initButton.EnableWindow(FALSE);  // disable the Init button
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box
}
	CWnd::SetActiveWindow();  // set focus back to our dialog
	
}

void CDISingleDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}
